/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, window */

'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'hbs!modules/jqm-modal-dialog/modalDialog' ],
    function (Portal, Backbone, Marionette, $, template) {
        return Backbone.Marionette.Layout.extend({
            attributes: {
                'data-role': 'dialog',
                'data-theme': 'a',
                'data-close-btn': 'right',
                'transition': 'fade'
            },
            template: template,
            regions: {
                'headerRegion': 'div[data-role=header]',
                'footerRegion': 'div[data-role=footer]',
                'contentRegion': 'div[data-role=content]'
            },
            model: new Backbone.Model(),
            // may give a static view (can include navbar in view) with options.header;
            // or if title changes/updates, give options.model with a title attribute
            initialize: function(options) {
                var self = this;

                if (typeof options.modalRegion !== 'undefined') {
                    this.modalRegion = options.modalRegion;
                } else {
                    this.modalRegion = Portal.modalRegion;
                }

                Portal.commands.setHandler("open-modal-dialog", function(options){
                    self.scrollable = (typeof options.scrollable !== 'undefined') ? !!options.scrollable : false;

                    self.modalRegion.show(self);

                    if ( typeof options.closeBtn !== 'undefined' ) {
                        self.attributes['data-close-btn'] = (!options.closeBtn) ? "none" : options.closeBtn;
                    }

                    if ( typeof options.header !== 'undefined' ) {
                        options.header.setElement(self.headerRegion.getEl('div[data-role=header]'));
                        options.header.render();
                    } else if (typeof options.model !== 'undefined') {
                        // new modal title view
                    }

                    if ( typeof options.footer !== 'undefined' ) {
                        options.footer.setElement(self.headerRegion.getEl('div[data-role=footer]'));
                        options.footer.render();
                    } else {
                        // delete if no footer given
                        self.removeRegion('footerRegion');
                        self.$el.find('div[data-role=footer]').remove();
                    }

                    self.historyFragment = (typeof options.historyFragment === 'undefined') ? (Backbone.history.previousFragment === Backbone.history.fragment ? '' : Backbone.history.previousFragment) : options.historyFragment;

                    self.contentRegion.show(options.content);
                    self.$el.dialog({ 'closeBtn': self.attributes['data-close-btn'] }).trigger('pagecreate');
                });

                Portal.commands.setHandler("close-modal-dialog", function(options){
                    self.closeModalDialog(options);
                });
            },
            events: {
                'pagehide': 'close',
                'pageshow': function() {
                    var self = this;
                    if (this.scrollable) {
                        $('#portal-modal .ui-content').attr('style', self.calculateHeightDialog());
                        $(window).on('resize.modal', function () {
                            $('#portal-modal .ui-content').attr('style', self.calculateHeightDialog());
                        });
                    }
                },
                'tap a[title="Close"]': function(e) {
                    e.preventDefault();
                    this.closeModalDialog();
                }
            },
            onShow: function() {
                var self = this;

                $.mobile.changePage( this.$el );
            },
            onClose: function() {
                if (this.scrollable) {
                    $(window).off('resize.modal');
                }
            },
            calculateHeightDialog: function () {
            var contentDiv = this.$el.find('div[data-role=content]'),
                marginTop = 0, marginBottom = 0,
                paddingTop = 15, paddingBottom = 15,
                top = (marginTop + paddingTop > 0) ? (marginTop + paddingTop) : 0,
                bottom = (marginBottom + paddingBottom > 0) ? (marginBottom + paddingBottom) : 0,
                populatedZones =
                    $(Portal.modalRegion.el).find('.ui-header').outerHeight() +
                    $(Portal.modalRegion.el).find('.ui-footer').outerHeight() +
                    top + bottom;

                return ('height:' + ($(window).innerHeight() - populatedZones) + 'px');
            },
            closeModalDialog: function(options) {
                var mainPage = $("div[data-role=page]:first-of-type"),
                    fragment = (typeof options !== "undefined" && typeof options.fragment !== "undefined") ? options.fragment : this.historyFragment;
                Portal.router.navigate(fragment, {trigger: true});
                $.mobile.changePage( mainPage );
            }
        });
    });